#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Ripples in BlackMod01.fsh  by   DwayneBrah
//https://www.shadertoy.com/view/ct23Rt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float ar;
vec2 outTexCoord;
vec4 final_color;

// A 2D point, moving in time with a sine wave function 
float dist_moving(float x_speed, float y_speed, float ripple_speed) {
	
    // Centre and correct aspect ratio
	vec2 corrected_coord = vec2(outTexCoord.x*ar-0.50, outTexCoord.y);
	
    // Set pace
	float time_adjusted = iTime*1.25;
	
    // The point and distance from curent XY
	vec2 point_1 = vec2(0.5*(sin(time_adjusted*x_speed)+1.00), 0.5*(sin(time_adjusted*y_speed)-0.50)+1.00);
	float point_1_dist = distance(point_1, corrected_coord);
	
    // Adjust distance scale ratio and return distance value
	float distance_multiplyer = 0.50;
    return(point_1_dist*distance_multiplyer);
	
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    // Set aspect ratio
    ar = iResolution.x/iResolution.y;

    // Normalise X & Y
    outTexCoord = vec2(fragCoord.x/iResolution.x, fragCoord.y/iResolution.y);
    
    // Create points and ripple the distance with a sine function
	float point_1_dist = dist_moving(-0.11, 0.17, 0.00);
	float point_1_dist_rippled = sin((point_1_dist)*30.00);
	
	float point_2_dist = dist_moving(0.04, -0.09, 0.04);
	float point_2_dist_rippled = sin(point_2_dist*30.00);
	
	float point_3_dist = dist_moving(0.09, 0.07, 0.33);
	float point_3_dist_rippled = sin(point_3_dist*30.00);
	
	// Create the coloured 'layer' 
	vec4 colorful_rings = vec4(abs(point_1_dist_rippled), abs(point_2_dist_rippled), abs(point_3_dist_rippled), 1.00);
	
    // Create the black & white 'layer' and ripple with a sinwave
	float color_intensity = (colorful_rings.r+colorful_rings.g+colorful_rings.b)/3.00;
	vec4 bw_rings = vec4(color_intensity, color_intensity, color_intensity, 1.00);
	float bw_rings_rippled = (sin(color_intensity*20.00));
	
    // Chose between 'layers'
    if (bw_rings_rippled > 0.50) {
		final_color = colorful_rings*colorful_rings;
	} else {
		final_color = vec4(bw_rings_rippled, bw_rings_rippled, bw_rings_rippled, 1.00);
	};
	
	// Output colour
	fragColor = final_color;
	
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

